/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HscCfgStatus;
import com.ibm.hsc.common.util.HscPerformance;
import com.ibm.hsc.common.util.HscPrintStream;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.ConsoleCmdMgr;
import com.ibm.hsc.fsp.ManagedSysConn;
import com.ibm.hsc.fsp.lockmgr.FspLockMgr;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.lock.RequestQueue;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.console.OmConsoleMgr;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RUtils;
import com.ibm.hsc.rep.v50.R50SchemaDigest;
import com.ibm.hsc.rep.v50.R50Test;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbem.provider.MethodProvider;
import org.snia.wbemcfg.GlobalConfig;

public class HSCSignalHandler
implements MethodProvider {
    public static final int SUCCESSFUL = 0;
    public static final int FAIL = -1;
    public static final HscCfgStatus cfgStatus = HscCfgStatus.getHscCfgStatus("/opt/hsc/data/cfgStatus");
    private ProviderCIMOMHandle mCIMOMHandle = null;
    private InstanceProvider mInstanceHandle = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        System.out.println("********************");
        System.out.println("In initialize...");
        this.mCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.mInstanceHandle = this.mCIMOMHandle.getInternalProvider();
        System.out.println("End of initialize");
        System.out.println("********************");
    }

    public void cleanup() throws CIMException {
        System.out.println("********************");
        System.out.println("In cleanup ... ");
        this.mInstanceHandle.cleanup();
        this.mInstanceHandle = null;
        this.mCIMOMHandle = null;
        System.out.println("End of cleanup");
        System.out.println("********************");
    }

    private void debug(String string) {
        System.out.println("| SignalHandler." + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        CIMValue cIMValue;
        System.out.println("method name: " + string);
        int n = 0;
        vector2.setSize(1);
        String[] stringArray = new String[]{"placeholder"};
        vector2.setElementAt(new CIMProperty("sigoutparms", new CIMValue((Object)stringArray, new CIMDataType(29))), 0);
        if (string.equals("sendSignal")) {
            CIMValue cIMValue2;
            if (GlobalConfig.callMethodsWithValues) {
                cIMValue = (CIMValue)vector.elementAt(0);
                cIMValue2 = (CIMValue)vector.elementAt(1);
            } else {
                cIMValue = ((CIMProperty)vector.elementAt(0)).getValue();
                cIMValue2 = ((CIMProperty)vector.elementAt(1)).getValue();
            }
            short s = ((UnsignedInt8)cIMValue.getValue()).shortValue();
            System.out.println("signal type: " + s);
            Vector vector3 = (Vector)cIMValue2.getValue();
            HscPrintStream hscPrintStream = null;
            switch (s) {
                case 1: {
                    hscPrintStream = HscPrintStream.getInstance();
                    if (hscPrintStream == null) break;
                    hscPrintStream.setTraceOn(null);
                    System.setOut(hscPrintStream);
                    System.setErr(hscPrintStream);
                    cfgStatus.setProperty("cimServerLog", "on");
                    break;
                }
                case 2: {
                    hscPrintStream = HscPrintStream.getInstance();
                    if (hscPrintStream != null) {
                        hscPrintStream.setTraceOff();
                    }
                    cfgStatus.setProperty("cimServerLog", "off");
                    break;
                }
                case 3: {
                    HSCEventIndicationMgr hSCEventIndicationMgr = HSCEventIndicationMgr.getInstance();
                    if (hSCEventIndicationMgr == null) break;
                    hSCEventIndicationMgr.printStatus();
                    break;
                }
                case 4: {
                    HscPerformance.enable();
                    break;
                }
                case 5: {
                    HscPerformance.disable();
                    break;
                }
                case 6: {
                    String string2 = (String)vector3.elementAt(0);
                    ManagedSysConn.setTimeoutValue(Integer.parseInt(string2));
                    break;
                }
                case 7: {
                    if (vector3.size() < 1) {
                        System.out.println("clearSaveArea: need to specify cec name");
                        break;
                    }
                    System.out.println("hscSignal 7: clearSaveArea for test only");
                    String string3 = (String)vector3.elementAt(0);
                    System.out.println("clearSaveArea: " + string3);
                    Lock lock = Lock.getInstance("root/ibmhscS1_0", string3);
                    lock.lock(1);
                    OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string3);
                    omCecMgr.getSaveArea().clearAll();
                    try {
                        lock.unlock();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                    catch (Throwable throwable) {
                        try {
                            throwable.printStackTrace();
                        }
                        catch (Throwable throwable2) {
                            try {
                                lock.unlock();
                            }
                            catch (Throwable throwable3) {
                                throwable3.printStackTrace();
                            }
                            throw throwable2;
                        }
                        try {
                            lock.unlock();
                        }
                        catch (Throwable throwable4) {
                            throwable4.printStackTrace();
                        }
                        break;
                    }
                }
                case 8: {
                    OmCecMgr.pushHscInfo();
                    break;
                }
                case 9: {
                    if (vector3.size() < 2) {
                        System.out.println("setCecState: need cec_name and state");
                        break;
                    }
                    System.out.println("hscSignal 9: set cec state for test only");
                    String string4 = (String)vector3.elementAt(0);
                    short s2 = Short.parseShort((String)vector3.elementAt(1));
                    System.out.println("cecName=" + string4);
                    System.out.println("cecState: " + s2);
                    Lock lock = Lock.getInstance("root/ibmhscS1_0", string4);
                    lock.lock(1);
                    OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string4);
                    omCecMgr.getCecStateChangeAct().setCecState(-1, s2);
                    omCecMgr.sendModifiedIndication(omCecMgr.getObject());
                    try {
                        lock.unlock();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                    catch (Throwable throwable) {
                        try {
                            throwable.printStackTrace();
                        }
                        catch (Throwable throwable5) {
                            try {
                                lock.unlock();
                            }
                            catch (Throwable throwable6) {
                                throwable6.printStackTrace();
                            }
                            throw throwable5;
                        }
                        try {
                            lock.unlock();
                        }
                        catch (Throwable throwable7) {
                            throwable7.printStackTrace();
                        }
                        break;
                    }
                }
                case 10: {
                    ConsoleCmdMgr.setPrintDetail(true);
                    break;
                }
                case 11: {
                    ConsoleCmdMgr.setPrintDetail(false);
                    break;
                }
                case 12: {
                    R50SchemaDigest r50SchemaDigest = new R50SchemaDigest((CIMOMHandle)this.mCIMOMHandle);
                    r50SchemaDigest.digestOfClassProperties();
                    break;
                }
                case 13: {
                    HardwareServerMessage.setCompleteDump(true);
                    break;
                }
                case 14: {
                    HardwareServerMessage.setCompleteDump(false);
                    break;
                }
                case 200: {
                    String string5 = (String)vector3.elementAt(0);
                    PrintWriter printWriter = null;
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream("/var/hsc/log/hmcdump.dat");
                        printWriter = new PrintWriter(fileOutputStream);
                        long l = System.currentTimeMillis();
                        Timestamp timestamp = new Timestamp(l);
                        printWriter.println(timestamp + ": dump repository for name space " + string5);
                        printWriter.println();
                        RUtils.dumpAllObjs(string5, printWriter);
                        RUtils.dumpAllAssos(string5, printWriter);
                        printWriter.println("===== end of dump =====");
                        printWriter.close();
                        break;
                    }
                    catch (RException rException) {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        rException.printStackTrace();
                        throw new CIMException(rException.getID());
                    }
                    catch (Throwable throwable) {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        throwable.printStackTrace();
                        throw new CIMException(throwable.getMessage());
                    }
                }
                case 201: {
                    try {
                        R50Test.runTest((CIMOMHandle)this.mCIMOMHandle);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
                case 202: {
                    System.out.println("print lock queues");
                    try {
                        RequestQueue.printAllQueues();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
                case 203: {
                    if (vector3.size() < 1) {
                        System.out.println("rebuildCec: need to specify cec name");
                        break;
                    }
                    String string6 = (String)vector3.elementAt(0);
                    System.out.println("rebuildCec: " + string6);
                    Lock lock = Lock.getInstance("root/ibmhscS1_0", string6);
                    lock.lock(1);
                    OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string6);
                    omCecMgr.updateCecAll();
                    try {
                        lock.unlock();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                    catch (Throwable throwable) {
                        try {
                            throwable.printStackTrace();
                        }
                        catch (Throwable throwable8) {
                            try {
                                lock.unlock();
                            }
                            catch (Throwable throwable9) {
                                throwable9.printStackTrace();
                            }
                            throw throwable8;
                        }
                        try {
                            lock.unlock();
                        }
                        catch (Throwable throwable10) {
                            throwable10.printStackTrace();
                        }
                        break;
                    }
                }
                case 204: {
                    n = 1;
                    if (vector3.size() < 2) {
                        n = 60;
                        break;
                    }
                    try {
                        String string7 = (String)vector3.elementAt(0);
                        if (string7 == null || string7.equals("$$Not$$Set$$")) {
                            string7 = null;
                        }
                        Byte by = new Byte((String)vector3.elementAt(1));
                        byte by2 = by;
                        String string8 = null;
                        if (vector3.size() > 2 && ((string8 = (String)vector3.elementAt(2)) == null || string8.equals("$$Not$$Set$$"))) {
                            string8 = null;
                        }
                        if (!OmConsoleMgr.getConsoleMgr().removeSys(string7, string8, by2)) break;
                        n = 0;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        n = 60;
                    }
                    break;
                }
                case 205: {
                    String string9 = "";
                    String string10 = "";
                    if (vector3.size() >= 1) {
                        string9 = (String)vector3.elementAt(0);
                    }
                    if (vector3.size() >= 2) {
                        string10 = (String)vector3.elementAt(1);
                    }
                    Lock lock = Lock.getInstance("root/ibmhscS1_0", string9, string10);
                    System.out.println("205: " + lock);
                    try {
                        lock.forceUnlockTopRunningRequest();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
                case 206: {
                    if (vector3.size() < 1) {
                        System.out.println("rebuildCec: need to specify cec name");
                        break;
                    }
                    String string11 = (String)vector3.elementAt(0);
                    System.out.println("dump fsp lock for: " + string11);
                    try {
                        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string11);
                        FspLockMgr fspLockMgr = omCecMgr.getFspLockMgr();
                        fspLockMgr.dumpAllFspLockRecords();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
                case 220: {
                    try {
                        String string12 = (String)vector3.elementAt(0);
                        System.out.println("HSCSignalHandler:  newTLevel =  " + string12);
                        if ("query".equals(string12)) {
                            System.out.println("HSCSignalHandler:  Query");
                            n = Trace.getLEVEL();
                            break;
                        }
                        System.out.println("HSCSignalHandler:  calling setLevel " + string12);
                        n = Trace.setLevel(string12);
                        if (n == -1) {
                            n = 51;
                            break;
                        }
                        Trace.persistTLevel(string12);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
                case 221: {
                    this.debug("signal 221:  Add connection.");
                    try {
                        if (vector3.size() < 1) {
                            n = 1;
                            break;
                        }
                        String string13 = (String)vector3.elementAt(0);
                        String string14 = null;
                        String string15 = null;
                        if (vector3.size() == 3) {
                            string14 = (String)vector3.elementAt(1);
                            string15 = (String)vector3.elementAt(2);
                        } else {
                            string15 = (String)vector3.elementAt(1);
                        }
                        this.debug("input param:ip=" + string13 + ", target=" + string15);
                        OmConsoleMgr.getConsoleMgr().addSys(string13, string14, Integer.parseInt(string15));
                        n = 0;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        n = 1;
                    }
                    break;
                }
                case 230: {
                    Object object;
                    int n2;
                    System.out.println("Entering 230:");
                    Vector vector4 = OmSysMgr.getAllSysIpAddr();
                    String string16 = null;
                    Vector<Object> vector5 = new Vector<Object>();
                    for (n2 = 0; n2 < vector4.size(); ++n2) {
                        string16 = "-";
                        try {
                            string16 = (String)vector4.elementAt(n2);
                            object = null;
                            String string17 = null;
                            InetAddress inetAddress = InetAddress.getByName(string16);
                            object = inetAddress.getHostName();
                            vector5.addElement(object);
                            System.out.println("host=" + (String)object);
                            string17 = inetAddress.getHostAddress();
                            System.out.println("ip=" + string17);
                            vector5.addElement(string17);
                            vector5.addElement("-");
                            continue;
                        }
                        catch (Throwable throwable) {
                            vector5.addElement("-");
                            vector5.addElement("-");
                            vector5.addElement(string16);
                            throwable.printStackTrace();
                        }
                    }
                    n2 = vector5.size();
                    object = null;
                    if (n2 > 0) {
                        object = new String[n2];
                        for (int i = 0; i < vector5.size(); ++i) {
                            object[i] = (String)vector5.elementAt(i);
                        }
                        vector2.setSize(1);
                        vector2.setElementAt(new CIMProperty("sigoutparms", new CIMValue(object, new CIMDataType(29))), 0);
                    }
                    System.out.println("Sending back " + object);
                    break;
                }
                case 231: {
                    System.out.println("Signal 231 received:");
                    try {
                        OmConsoleMgr.getConsoleMgr().reboot();
                        n = 0;
                        break;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        n = 1;
                    }
                }
            }
        }
        System.out.println("HSCSignalHandler:  methodRC = " + n);
        cIMValue = new UnsignedInt8((short)n);
        return new CIMValue((Object)cIMValue, new CIMDataType(1));
    }
}

